<?php

declare(strict_types=1);

/*
|--------------------------------------------------------------------------
| server:
|--------------------------------------------------------------------------
*/

const INSTALLATION_URL = 'http://localhost';

// for developing admin panel, use localhost
// for developing mobile app,  use 10.0.2.2

/*
|--------------------------------------------------------------------------
| Database:
|--------------------------------------------------------------------------
*/

// database server host, localhost if local
const DATABASE_HOST = 'localhost';

// database user credentials
const DATABASE_USER = 'database_user';
const DATABASE_PASS = 'database_pass';
const DATABASE_NAME = 'database_name';

/*
|--------------------------------------------------------------------------
| Database advance setup:
|--------------------------------------------------------------------------
*/

// Type of database server
const DATABASE_TYPE = DATABASE_TYPE_MYSQL;

// Database port. Will use default if not set, therefore you can leave it empty
const DATABASE_PORT = '';

/*
|--------------------------------------------------------------------------
| Admin Panel configuration:
|--------------------------------------------------------------------------
*/

const ADMIN_CLIENT_DIR_NAME = 'admin';

const ADMIN_CLIENT_TITLE = 'Photogram';

/*
|--------------------------------------------------------------------------
| Debugging:
|--------------------------------------------------------------------------
*/

// log errors
const MODE_LOG_ERRORS = false;

// display errors to end users
const MODE_DISPLAY_ERRORS = false;

// log incoming request on hit
const MODE_LOG_REQUEST_DISPATCH = false;

// log outgoing response on dispatch
const MODE_LOG_RESPONSE_DISPATCH = false;

// log database ops such as queries
const MODE_LOG_DATABASE_ADAPTER = false;

// freeze schema(set it to false for development)
const FREEZE_SCHEMA = true;

/*
|--------------------------------------------------------------------------
| Admin panel's debugging:
|--------------------------------------------------------------------------
*/

const ADMIN_CLIENT_DEBUG = false;

/*
|--------------------------------------------------------------------------
| safety measures
|--------------------------------------------------------------------------
*/

const CURL_CONNECTION_TIMEOUT = 5;

const CURL_SESSION_TIMEOUT = 15;
